function weather() {
  if [ -z "$1" ]; then
    echo "Usage: weather <city>"
    return 1
  fi

  local weather
  weather=$(curl -s "wttr.in/$1?format=%C")

  case "$weather" in
    *Clear*) echo "☀️  It's sunny in $1!" ;;
    *Cloud*) echo "☁️  It's cloudy in $1!" ;;
    *Rain*)  echo "🌧️  It's raining in $1!" ;;
    *Snow*)  echo "❄️  It's snowing in $1!" ;;
    *Storm*) echo "⛈️  There's a storm in $1!" ;;
    *)       echo "🌦️  The weather in $1 is: $weather" ;;
  esac
}
