safe_rm() {
  if [[ "$*" =~ (^| )/($| ) ]]; then
    echo "Error: Attempt to use 'rm' on root (/) is blocked for your safety!"
    return 1
  elif [[ "$*" =~ "--no-preserve-root" ]]; then
    echo "Error: '--no-preserve-root' usage is blocked for your safety!"
    return 1
  fi

  command rm "$@"
}

alias rm="safe_rm"

