fireworks() {
    # Check for lolcat
    if ! command -v lolcat &>/dev/null; then
        echo "Please install 'lolcat': sudo pacman -S lolcat" >&2
        return 1
    fi

    # Simpler firework patterns
    local -a firework=(
        "    *    "
        "  * * *  "
        "* * * * *"
        "    |    "
    )

    clear
    while true; do
        # Print some random fireworks
        for ((i=0; i<3; i++)); do
            position=$((RANDOM % 70))
            spaces=$(printf '%*s' $position '')

            for pattern in "${firework[@]}"; do
                echo "${spaces}${pattern}" | lolcat -f
                sleep 0.1
            done

            # Add explosion effect
            echo "${spaces}  * * *  " | lolcat -f
            echo "${spaces} *  *  * " | lolcat -f
            echo "${spaces}*   *   *" | lolcat -f
            sleep 0.2
        done

        # Check for keyboard input to exit
        read -t 0.1 -n 1 input
        if [[ $? -eq 0 ]]; then
            break
        fi
    done
    echo
}