# window.py
#
# Copyright 2025 parchlinux
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from subprocess import Popen

from gi.repository import Adw
from gi.repository import Gtk

from . import i18n, utils


@Gtk.Template(resource_path="/com/parchlinux/dorood/window.ui")
class DoroodWindow(Adw.ApplicationWindow):
    __gtype_name__ = "DoroodWindow"



    status_page = Gtk.Template.Child("status_page")
    toggle_button = Gtk.Template.Child("toggle_button")
    start_button = Gtk.Template.Child("start_button")

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.lang = "en"

    @Gtk.Template.Callback()
    def toggle_button_clicked(self, *args):
        self.lang = "fa" if self.lang == "en" else "en"
        strings = i18n.STRINGS[self.lang]
        self.status_page.set_title(strings["dorood"])
        self.status_page.set_description(strings["subtitle"])
        self.start_button.set_label(strings["start"])

    @Gtk.Template.Callback()
    def start_button_clicked(self, *args):
        if utils.is_calamares_installed():
            Popen(["sudo", "-E", "calamares"])
            Gtk.Application.get_default().quit()
        else:
            dialog = Adw.AlertDialog()
            dialog.set_heading(i18n.STRINGS[self.lang]["error_title"])
            dialog.set_body(i18n.STRINGS[self.lang]["calamares_error"])
            dialog.add_response("OK",  i18n.STRINGS[self.lang]["ok"])
            dialog.set_default_response("OK")
            dialog.set_close_response("OK")
            dialog.present(self)
