import os
import shutil

def setup_environment():
    os.environ["LIBGL_DEBUG"] = "quiet"

    if "GDK_BACKEND" not in os.environ:
        session = os.environ.get("XDG_SESSION_TYPE", "").lower()
        if session == "wayland":
            os.environ["GDK_BACKEND"] = "wayland"
        elif session == "x11":
            os.environ["GDK_BACKEND"] = "x11"
        else:
            os.environ["GDK_BACKEND"] = "wayland,x11"

def is_calamares_installed() -> bool:
    return shutil.which("calamares") is not None
