from .baseSterategy import base_strategy
import domain
import os
import settings
from .promises import resolvd as resolvdPromise, resolv_conf as resolvConfPromise

class resolvd(base_strategy):
    def check4resovConfFile(self):
        def isOk():
            d = open('/etc/resolv.conf','r').read()
            for line in d.splitlines():
                try:
                    line = line.strip()
                    if line[:10] == 'nameserver':
                        return (line[10:]).strip() == '127.0.0.53'
                except:...
            return False
        if not isOk():
            resolvconffile = f'''
#Generated By NAMBAN

#Connect to systemd-resolvd
nameserver 127.0.0.53
'''.strip()
            os.system(
                "cp /etc/resolv.conf " + str(settings.APP_FILES_PATH/'oldconffiles/resolv.conf') + " -r"
            )
            with open('/etc/resolv.conf', 'w+') as f:
                f.write(resolvconffile)
                f.close()
            self.promises.append(
                resolvConfPromise((settings.APP_FILES_PATH/'oldconffiles/resolv.conf').__str__())
            )
    def generateResolvdConf(self):
        profile = self.profile
        c = f'''
# Generated By NAMBAN
[Resolve]
DNS={profile.server1.url}
'''.strip()
        if profile.server2:
            c += f'\nFallbackDNS={profile.server2.url}'
        return c
    def connect(self):
        self.check4resovConfFile()
        os.system(f"cp /etc/systemd/resolved.conf "+str(settings.APP_FILES_PATH/'oldconffiles/resolved.conf') + " -r")
        with open("/etc/systemd/resolved.conf",'w+') as f:
            f.write(
                self.generateResolvdConf()
            )
            f.close()
        os.system('systemctl daemon-reload')
        os.system('systemctl restart systemd-resolved')
        self.promises.append(
            resolvdPromise((settings.APP_FILES_PATH/'oldconffiles/resolved.conf').__str__())
        )
    def disconnect(self):
        while len(self.promises):
            p = self.promises.pop()
            p.handle()
        os.system('systemctl daemon-reload')
        os.system('systemctl restart systemd-resolved')
        
