#!/bin/sh

# Enable flathub
arch-chroot ${workdir} flatpak remote-add --if-not-exists flathub https://flathub.org/repo/flathub.flatpakrepo

# Enable OpenNIC DNS servers
arch-chroot ${workdir} systemctl enable opennic-up-on-boot
arch-chroot ${workdir} systemctl enable opennic-up.timer

# Remove pacman
arch-chroot ${workdir} sed -i -e '/HoldPkg = pacman/d' /etc/pacman.conf
arch-chroot ${workdir} pacman -Scc --noconfirm
arch-chroot ${workdir} pacman -Rdd pacman pacman-mirrors --noconfirm

# Delete pacman database local cache
[[ -d "${workdir}/var/lib/pacman/local" ]] && find "${workdir}/var/lib/pacman/local" -mindepth 1 -delete
# Delete pacman package configs
[[ -d "${workdir}/etc/pacman.d" ]] && find "${workdir}/etc/pacman.d" -type f -delete
[[ -d "${workdir}/etc/pacman.conf" ]] && find "${workdir}/etc/pacman.conf" -type f -delete
